/* Max C interface to the CDEV Manager by Greg Branche
 * (based on the MAX Pascal interface file by Darryl Lovato)
 * Copyright (c) 1989-1990 by Apple Computer, Inc.
 */

#ifndef __CDev__
#define __CDev__

#define	MachineCDEV		1		/* machine test, return 0 if NOT ok to run on this machine */
#define	BootCDEV		2		/* boot time init call or Install call - no parms */
#define	ShutDownCDEV	3		/* shut down or de-install the CDEV - no parms */
#define	InitCDEV		4		/* called when being shown - data1 = windowPtr */
#define	CloseCDEV		5		/* called when being removed - data1 = windowPtr */
#define	EventsCDEV		6		/* called when an event - data1 = ptr to event record */
#define	CreateCDEV		7		/* called so that a CDEV can create its controls inline - data1 = window */
#define	AboutCDEV		8		/* called so that a CDEV can create its about text inline - no parms */
#define	RectCDEV		9		/* called so that a CDEV can dynamically compute its rectangle data1 = rectprr */
#define	HitCDEV			10		/* called when ctl is "hit" - data1 = Hdl to ctl hit, data2 = Ctl Id */
#define	RunCDEV			11		/* called when daRun is called */
#define	reserved1		12		/* reserved for Apple Computer's future use */
#define	reserved2		13		/* reserved for Apple Computer's future use */
#define	reserved3		14		/* reserved for Apple Computer's future use */
#define	NeverUsed1		15
#define	NeverUsed2		16

#define	wantMachine		1		/* these flags are set in the CDEV flags resource to tell the Control */
#define	wantBoot		2		/* panel which of the above messages the CDEV actually needs */
#define	wantShutDown	4
#define	wantInit		8
#define	wantClose		16
#define	wantEvents		32
#define	wantCreate		64
#define	wantAbout		128
#define	wantRect		256
#define	wantHit			512
#define	wantRun			1024
#define	wantReserved1	2048
#define	wantReserved2	4096
#define	wantReserved3	8192
#define	updateSSfromBRAM 16384	/* this is for use by Apple Computer, Inc ONLY! <- I mean it! */
#define	CanBeUnActive	32768	/* set this bit if the cdev can be made inactive by the user */

#endif